<?php if (!defined('ABSPATH')) exit; //Exit if accessed directly ?>

<?php

$v = time();
$base = STM_LMS_URL . '/post_type/metaboxes/assets/';
$assets = STM_LMS_URL . 'assets';

stm_lms_register_style('course');
stm_lms_register_style('lesson');
stm_lms_register_style('manage_course');
wp_enqueue_style('stm-lms-metaboxes.css', $base . 'css/main.css', array(), $v);
wp_enqueue_style('stm-lms-icons', STM_LMS_URL . 'assets/icons/style.css', array(), $v);
wp_enqueue_style('linear-icons', $base . 'css/linear-icons.css', array('stm-lms-metaboxes.css'), $v);
wp_enqueue_style('font-awesome-min', $assets . '/vendors/font-awesome.min.css', NULL, $v, 'all');

stm_lms_pro_register_script('vue-tinymce/tinymce.min');
stm_lms_pro_register_script('vue-tinymce/vue-easy-tinymce.min');
wp_enqueue_script('sortable.js', $base . 'js/sortable.min.js', array('vue.js'), $v);
wp_enqueue_script('vue-draggable.js', STM_LMS_URL . 'post_type/metaboxes/assets/js/vue-draggable.min.js', array('sortable.js'), 1, false);
wp_add_inline_script('vue-draggable.js', 'const STM_LMS_EventBus = new Vue();');

wp_enqueue_script('vue2-editor.js', $base . 'js/vue2-editor.min.js', array('vue.js'), $v);
wp_enqueue_script('vue-select2.js', STM_LMS_URL . 'post_type/metaboxes/assets/js/vue-select.js', array(), 1, false);
stm_lms_pro_register_script('manage_course', array('vue.js', 'vue-resource.js'));
wp_add_inline_script('stm-lms-manage_course', STM_LMS_Manage_Course::localize_script($course_id), 'before');
wp_enqueue_editor(); ?>

<div id="stm_lms_manage_course" v-bind:class="{'loading' : loading}">

    <div class="container">

        <div class="row">

            <div class="col-md-9">

                <div class="stm_lms_manage_course stm_lms_manage_course__text stm_lms_manage_course__title stm_lms_wizard_step_1">
                    <h1 class="stm_lms_course__title" v-html="fields['title']" v-if="fields['title']"></h1>
                    <h1 class="stm_lms_course__title stm_lms_phantom" v-html="i18n['title']"
                        v-if="!fields['title']"></h1>
					<?php STM_LMS_Templates::show_lms_template(
						'manage_course/forms/text',
						array('field_key' => 'title')
					); ?>
                </div>

				<?php STM_LMS_Templates::show_lms_template('manage_course/parts/panel_info'); ?>

				<?php STM_LMS_Templates::show_lms_template('manage_course/parts/tabs'); ?>

            </div>

            <div class="col-md-3">

				<?php STM_LMS_Templates::show_lms_template('manage_course/sidebar'); ?>

            </div>

        </div>

        <div class="stm_lms_manage_course__actions">
            <a href="#" class="btn btn-default" @click.prevent="saveCourse()">
                <span v-if="!fields['post_id']"><?php esc_html_e('Publish Course', 'masterstudy-lms-learning-management-system-pro'); ?></span>
                <span v-else><?php esc_html_e('Update Course', 'masterstudy-lms-learning-management-system-pro'); ?></span>
            </a>
        </div>

        <transition name="slide-fade">
            <div class="stm-lms-message" v-bind:class="status" v-if="message" v-html="message"></div>
        </transition>

		<?php STM_LMS_Templates::show_lms_template('manage_course/wizard/main'); ?>

    </div>

</div>